/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.assets.entities.item;

import com.google.inject.ProvidedBy;
import com.google.inject.Singleton;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import technology.rocketjump.undermount.assets.entities.EntityAssetTypeDictionary;
import technology.rocketjump.undermount.assets.entities.item.ItemEntityAssetDictionaryProvider;
import technology.rocketjump.undermount.assets.entities.item.ItemEntityAssetsByQuantity;
import technology.rocketjump.undermount.assets.entities.item.model.ItemEntityAsset;
import technology.rocketjump.undermount.assets.entities.model.EntityAssetType;
import technology.rocketjump.undermount.entities.model.physical.item.ItemEntityAttributes;
import technology.rocketjump.undermount.entities.model.physical.item.ItemTypeDictionary;

@ProvidedBy(value=ItemEntityAssetDictionaryProvider.class)
@Singleton
public class ItemEntityAssetDictionary {
    private final ItemEntityAssetsByQuantity quantityMap;
    private final Map<String, ItemEntityAsset> assetsByName = new HashMap<String, ItemEntityAsset>();

    public ItemEntityAssetDictionary(List<ItemEntityAsset> completeAssetList, EntityAssetTypeDictionary entityAssetTypeDictionary, ItemTypeDictionary itemTypeDictionary) {
        this.quantityMap = new ItemEntityAssetsByQuantity(entityAssetTypeDictionary, itemTypeDictionary);
        for (ItemEntityAsset asset : completeAssetList) {
            this.quantityMap.add(asset);
            this.assetsByName.put(asset.getUniqueName(), asset);
        }
    }

    public ItemEntityAsset getByUniqueName(String uniqueAssetName) {
        ItemEntityAsset asset = this.assetsByName.get(uniqueAssetName);
        if (asset != null) {
            return asset;
        }
        System.err.println("Could not find asset by name " + uniqueAssetName);
        return null;
    }

    public ItemEntityAsset getItemEntityAsset(EntityAssetType assetType, ItemEntityAttributes attributes) {
        return this.quantityMap.get(assetType, attributes);
    }

    public List<ItemEntityAsset> getAllMatchingAssets(EntityAssetType assetType, ItemEntityAttributes attributes) {
        return this.quantityMap.getAll(assetType, attributes);
    }
}

